package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.Strength;
import com.hero.objects.powers.CustomPower;
import com.hero.objects.powers.NakedModifier;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ReducedEND extends Modifier {

	private static String xmlID = "REDUCEDEND";

	public ReducedEND(Element root) {
		super(root, ReducedEND.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		double val = getTotalValue();
		ret += " (";
		if (getSelectedOption() != null) {
			ret += getSelectedOption().getAlias();
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += " ";
			}
			ret += getInput();
		}
		ret = ret.trim();
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		int index = 0;
		int parenCount = 0;
		while (ret.indexOf("(", index) >= 0) {
			parenCount++;
			index = ret.indexOf("(", index) + 1;
		}
		index = 0;
		while (ret.indexOf(")", index) >= 0) {
			parenCount--;
			index = ret.indexOf(")", index) + 1;
		}
		if (parenCount <= 0) {
			ret += " (";
		} else {
			ret += "; ";
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isSelected()) {
				continue;
			}
			if (ad.getColumn2Output().trim().length() > 0) {
				ret += ad.getColumn2Output().trim() + "; ";
			}
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		if ((val > maxCost) && maxSet) {
			val = maxCost;
		}
		if ((val < minimumCost) && minSet) {
			val = minimumCost;
		}
		ret += getFraction(val) + ")";
		parenCount--;
		while (parenCount > 0) {
			ret += ")";
			parenCount--;
		}
		if (adderString.trim().length() > 0) {
			if (ret.trim().length() > 0) {
				ret += ", ";
			}
			ret += adderString;
		}
		return ret;
	}

	@Override
	public double getTotalValue() {
		double ret = super.getTotalValue();
		if (parent != null) {
			if (GenericObject.findObjectByID(parent.getAssignedModifiers(),
					"AUTOFIRE") != null) {
				ret = ret * 2;
			}
		}
		return ret;
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		o = o.clone();
		o.setParent(null);
		o.setMainPower(null);
		if (GenericObject.findObjectByID(o.getAssignedModifiers(),
				"INCREASEDEND") != null) {
			return getDisplay()
					+ " cannot be applied to an ability with the Increased END Limitation.";
		}
		if (GenericObject.findObjectByID(o.getAssignedModifiers(), "COSTSEND") != null) {
			return getDisplay()
					+ " cannot be applied to an ability with the Costs END Limitation.";
		}
		if (GenericObject.findObjectByID(o.getAssignedModifiers(),
				"COSTSENDONLYTOACTIVATE") != null) {
			return getDisplay()
					+ " cannot be applied to an ability with Costs END Only To Activate.";
		}
		if (GenericObject.findObjectByID(o.getAssignedModifiers(),
				"COSTSENDTOMAINTAIN") != null) {
			return getDisplay()
					+ " cannot be applied to an ability with Costs END To Maintain.";
		}
		if ((o instanceof Multipower) || (o instanceof ElementalControl)) {
			return "";
		}
		if ((o instanceof NakedModifier) || (o instanceof CustomPower)) {
			if (o.getAPPerEnd() != 0) {
				return "";
			}
		}
		GenericObject chargesHolder = GenericObject.findObjectByID(o
				.getAssignedModifiers(), "CHARGES");
		if (chargesHolder != null) {
			o.getAssignedModifiers().remove(chargesHolder);
		}
		if (o instanceof Characteristic) {
			Characteristic ch = (Characteristic) o;
			if (ch.addModifiersToBase()
					&& (HeroDesigner.getActiveHero() != null)) {
				ch = HeroDesigner.getActiveHero().getCharacteristic(
						ch.getType());
				int charEnd = ch.getEndUsage();
				if (ch instanceof Strength) {
					Strength str = (Strength) ch;
					charEnd = str.getPrimaryEND();
				}
				if ((charEnd == 0) && (o.getEndUsage() == 0)) {
					if (chargesHolder != null) {
						o.getAssignedModifiers().add((Modifier) chargesHolder);
					}
					return o.getDisplay() + " does not cost END.";
				} else {
					if (chargesHolder != null) {
						o.getAssignedModifiers().add((Modifier) chargesHolder);
					}
					return "";
				}
			} else if (o.getEndUsage() == 0) {
				if (chargesHolder != null) {
					o.getAssignedModifiers().add((Modifier) chargesHolder);
				}
				return o.getDisplay() + " does not cost END.";
			} else {
				if (chargesHolder != null) {
					o.getAssignedModifiers().add((Modifier) chargesHolder);
				}
				return "";
			}
		} else if (o.getEndUsage() == 0) {
			if (chargesHolder != null) {
				o.getAssignedModifiers().add((Modifier) chargesHolder);
			}
			return o.getDisplay() + " does not cost END.";
		} else {
			if (chargesHolder != null) {
				o.getAssignedModifiers().add((Modifier) chargesHolder);
			}
			return "";
		}
	}
}